/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Contract_Price;
import drr.regulation.common.functions.Contract_StrikePrice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CDEExchangeRateRuleDefault.class)
public abstract class CDEExchangeRateRule
implements ReportFunction<TransactionReportInstruction, PriceSchedule> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected Contract_StrikePrice contract_StrikePrice;

    public PriceSchedule evaluate(TransactionReportInstruction input) {
        PriceSchedule output;
        PriceSchedule.PriceScheduleBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction var1);

    public static class CDEExchangeRateRuleDefault
    extends CDEExchangeRateRule {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input) {
            PriceSchedule.PriceScheduleBuilder output = PriceSchedule.builder();
            return this.assignOutput(output, input);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder output, TransactionReportInstruction input) {
            MapperC thenArg = MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperC.of(this.contract_Price.evaluate(input)), MapperC.of(this.contract_StrikePrice.evaluate(input))}).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.notExists((Mapper)item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()))).get());
            output = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)thenArg.last().get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

