/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.product.common.settlement.Cashflow;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import java.math.BigDecimal;

@ImplementedBy(value=CDEFXNotionalRuleDefault.class)
public abstract class CDEFXNotionalRule
implements ReportFunction<Cashflow, BigDecimal> {
    public BigDecimal evaluate(Cashflow input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(Cashflow var1);

    public static class CDEFXNotionalRuleDefault
    extends CDEFXNotionalRule {
        @Override
        protected BigDecimal doEvaluate(Cashflow input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, Cashflow input) {
            output = (BigDecimal)MapperS.of((Object)input).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get();
            return output;
        }
    }
}

