/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.PriceOfEvent;
import drr.regulation.common.functions.PriceOfZeroCouponSwaps;
import drr.regulation.common.functions.ProductForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=CDEPriceRuleDefault.class)
public abstract class CDEPriceRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected PriceOfEvent priceOfEvent;
    @Inject
    protected PriceOfZeroCouponSwaps priceOfZeroCouponSwaps;
    @Inject
    protected ProductForEvent productForEvent;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class CDEPriceRuleDefault
    extends CDEPriceRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            Boolean _boolean = this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(this.productForEvent.evaluate(input));
            if (_boolean != null && _boolean.booleanValue()) {
                MapperC thenArg0 = MapperC.of(this.priceOfZeroCouponSwaps.evaluate(input));
                MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
                output = (BigDecimal)MapperS.of((Object)((BigDecimal)thenArg1.get())).get();
            } else {
                output = this.priceOfEvent.evaluate(input);
            }
            return output;
        }
    }
}

