/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.functions;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.mapper.Mapper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public class CalculationFunction<T extends RosettaModelObject, R>
implements Function<T, Mapper<? extends R>> {
    private final Function<CalculationArgs, Mapper<? extends R>> function;
    private final CalculationArgFunctions<T> argFunctions;

    public CalculationFunction(Function<CalculationArgs, Mapper<? extends R>> function, CalculationArgFunctions<T> argFunctions) {
        this.function = function;
        this.argFunctions = argFunctions;
    }

    @Override
    public Mapper<? extends R> apply(CalculationArgs args) {
        return this.function.apply(args);
    }

    @Override
    public Mapper<? extends R> apply(T input) {
        CalculationArgs args = this.argFunctions.toArgs(input);
        return this.apply((T)args);
    }

    public static class CalculationArgFunctions<T>
    extends HashMap<String, Function<T, Mapper<?>>> {
        private static final long serialVersionUID = 1L;

        public CalculationArgs toArgs(T input) {
            BiConsumer<CalculationArgs, Map.Entry> accumulator = (args, entry) -> args.put((String)entry.getKey(), (Mapper)((Function)entry.getValue()).apply(input));
            BinaryOperator combiner = (args1, args2) -> {
                args1.putAll(args2);
                return args1;
            };
            Collector<Map.Entry, CalculationArgs, CalculationArgs> col = Collector.of(CalculationArgs::new, accumulator, combiner, new Collector.Characteristics[0]);
            return this.entrySet().stream().collect(col);
        }
    }

    public static class CalculationArgs
    extends HashMap<String, Mapper<?>> {
        private static final long serialVersionUID = 1L;
    }
}

