/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.PropertySet;

public final class PropertiesFile {
    private final PropertySet keyValueMap;

    public static PropertiesFile of(CharSource source) {
        ArgChecker.notNull(source, "source");
        ImmutableList lines = Unchecked.wrap(() -> source.readLines());
        PropertySet keyValues = PropertiesFile.parse((ImmutableList<String>)lines);
        return new PropertiesFile(keyValues);
    }

    private static PropertySet parse(ImmutableList<String> lines) {
        ImmutableListMultimap.Builder parsed = ImmutableListMultimap.builder();
        int lineNum = 0;
        for (String line : lines) {
            String value;
            ++lineNum;
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
            int equalsPosition = line.indexOf(" = ");
            equalsPosition = equalsPosition < 0 ? line.indexOf(61) : equalsPosition + 1;
            String key = equalsPosition < 0 ? line.trim() : line.substring(0, equalsPosition).trim();
            String string = value = equalsPosition < 0 ? "" : line.substring(equalsPosition + 1).trim();
            if (key.length() == 0) {
                throw new IllegalArgumentException("Invalid properties file, empty key, line " + lineNum);
            }
            parsed.put((Object)key, (Object)value);
        }
        return PropertySet.of((Multimap<String, String>)parsed.build());
    }

    public static PropertiesFile of(PropertySet keyValueMap) {
        ArgChecker.notNull(keyValueMap, "keyValueMap");
        return new PropertiesFile(keyValueMap);
    }

    private PropertiesFile(PropertySet keyValueMap) {
        this.keyValueMap = keyValueMap;
    }

    public PropertySet getProperties() {
        return this.keyValueMap;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertiesFile) {
            return this.keyValueMap.equals(((PropertiesFile)obj).keyValueMap);
        }
        return false;
    }

    public int hashCode() {
        return this.keyValueMap.hashCode();
    }

    public String toString() {
        return this.keyValueMap.toString();
    }
}

