package drr.enrichment.common.valuation.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportableValuation;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_StandaloneValuationFromReportableEvent.Create_StandaloneValuationFromReportableEventDefault.class)
public abstract class Create_StandaloneValuationFromReportableEvent implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_ValuationDetailsFromReportableEvent create_ValuationDetailsFromReportableEvent;

	/**
	* @param reportableEvent 
	* @return standaloneValuation 
	*/
	public ReportableValuation evaluate(ReportableEvent reportableEvent) {
		ReportableValuation.ReportableValuationBuilder standaloneValuationBuilder = doEvaluate(reportableEvent);
		
		final ReportableValuation standaloneValuation;
		if (standaloneValuationBuilder == null) {
			standaloneValuation = null;
		} else {
			standaloneValuation = standaloneValuationBuilder.build();
			objectValidator.validate(ReportableValuation.class, standaloneValuation);
		}
		
		return standaloneValuation;
	}

	protected abstract ReportableValuation.ReportableValuationBuilder doEvaluate(ReportableEvent reportableEvent);

	public static class Create_StandaloneValuationFromReportableEventDefault extends Create_StandaloneValuationFromReportableEvent {
		@Override
		protected ReportableValuation.ReportableValuationBuilder doEvaluate(ReportableEvent reportableEvent) {
			ReportableValuation.ReportableValuationBuilder standaloneValuation = ReportableValuation.builder();
			return assignOutput(standaloneValuation, reportableEvent);
		}
		
		protected ReportableValuation.ReportableValuationBuilder assignOutput(ReportableValuation.ReportableValuationBuilder standaloneValuation, ReportableEvent reportableEvent) {
			standaloneValuation = toBuilder(ReportableValuation.builder()
				.setValuationDetails(create_ValuationDetailsFromReportableEvent.evaluate(reportableEvent))
				.setReportableInformation(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get())
				.build());
			
			return Optional.ofNullable(standaloneValuation)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
