package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.FixedRate10__1;
import iso20022.auth030.jfsa.InterestComputationMethod4Code;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_FixedRateLeg1.Create_FixedRateLeg1Default.class)
public abstract class Create_FixedRateLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_FixedRate10__1 create_FixedRate10__1;

	/**
	* @param drrReport 
	* @return fxd 
	*/
	public FixedRate10__1 evaluate(JFSATransactionReport drrReport) {
		FixedRate10__1.FixedRate10__1Builder fxdBuilder = doEvaluate(drrReport);
		
		final FixedRate10__1 fxd;
		if (fxdBuilder == null) {
			fxd = null;
		} else {
			fxd = fxdBuilder.build();
			objectValidator.validate(FixedRate10__1.class, fxd);
		}
		
		return fxd;
	}

	protected abstract FixedRate10__1.FixedRate10__1Builder doEvaluate(JFSATransactionReport drrReport);

	public static class Create_FixedRateLeg1Default extends Create_FixedRateLeg1 {
		@Override
		protected FixedRate10__1.FixedRate10__1Builder doEvaluate(JFSATransactionReport drrReport) {
			FixedRate10__1.FixedRate10__1Builder fxd = FixedRate10__1.builder();
			return assignOutput(fxd, drrReport);
		}
		
		protected FixedRate10__1.FixedRate10__1Builder assignOutput(FixedRate10__1.FixedRate10__1Builder fxd, JFSATransactionReport drrReport) {
			fxd = toBuilder(create_FixedRate10__1.evaluate(MapperS.of(drrReport).<BigDecimal>map("getFixedRateLeg1", jFSATransactionReport -> jFSATransactionReport.getFixedRateLeg1()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFixedRateDayCountConventionLeg1", jFSATransactionReport -> jFSATransactionReport.getFixedRateDayCountConventionLeg1()).map("to-string", InterestComputationMethod4Code::toDisplayString).get(), MapperS.of(drrReport).<String>map("getFixedRatePaymentFrequencyPeriodLeg1", jFSATransactionReport -> jFSATransactionReport.getFixedRatePaymentFrequencyPeriodLeg1()).get(), MapperS.of(drrReport).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplierLeg1", jFSATransactionReport -> jFSATransactionReport.getFixedRatePaymentFrequencyPeriodMultiplierLeg1()).get()));
			
			return Optional.ofNullable(fxd)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
