package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.SpreadOfLeg2;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.jfsa.FloatingRate13__1;
import iso20022.auth030.jfsa.InterestComputationMethod4Code;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_FloatingRateLeg2.Create_FloatingRateLeg2Default.class)
public abstract class Create_FloatingRateLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_FloatingRate13__1 create_FloatingRate13__1;

	/**
	* @param drrReport 
	* @return fltg 
	*/
	public FloatingRate13__1 evaluate(JFSATransactionReport drrReport) {
		FloatingRate13__1.FloatingRate13__1Builder fltgBuilder = doEvaluate(drrReport);
		
		final FloatingRate13__1 fltg;
		if (fltgBuilder == null) {
			fltg = null;
		} else {
			fltg = fltgBuilder.build();
			objectValidator.validate(FloatingRate13__1.class, fltg);
		}
		
		return fltg;
	}

	protected abstract FloatingRate13__1.FloatingRate13__1Builder doEvaluate(JFSATransactionReport drrReport);

	public static class Create_FloatingRateLeg2Default extends Create_FloatingRateLeg2 {
		@Override
		protected FloatingRate13__1.FloatingRate13__1Builder doEvaluate(JFSATransactionReport drrReport) {
			FloatingRate13__1.FloatingRate13__1Builder fltg = FloatingRate13__1.builder();
			return assignOutput(fltg, drrReport);
		}
		
		protected FloatingRate13__1.FloatingRate13__1Builder assignOutput(FloatingRate13__1.FloatingRate13__1Builder fltg, JFSATransactionReport drrReport) {
			fltg = toBuilder(create_FloatingRate13__1.evaluate(MapperS.of(drrReport).<String>map("getNameOfTheFloatingRateOfLeg2", jFSATransactionReport -> jFSATransactionReport.getNameOfTheFloatingRateOfLeg2()).get(), MapperS.of(drrReport).<String>map("getIndicatorOfTheFloatingRateOfLeg2", jFSATransactionReport -> jFSATransactionReport.getIndicatorOfTheFloatingRateOfLeg2()).get(), MapperS.of(drrReport).<String>map("getFloatingRateReferencePeriodOfLeg2TimePeriod", jFSATransactionReport -> jFSATransactionReport.getFloatingRateReferencePeriodOfLeg2TimePeriod()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateReferencePeriodOfLeg2Multiplier", jFSATransactionReport -> jFSATransactionReport.getFloatingRateReferencePeriodOfLeg2Multiplier()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Monetary", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Monetary()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Decimal", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Decimal()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Basis", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Basis()).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg2", spreadOfLeg2 -> spreadOfLeg2.getSpreadCurrencyOfLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadOfLeg2>map("getSpreadOfLeg2", jFSATransactionReport -> jFSATransactionReport.getSpreadOfLeg2()).<PriceNotationEnum>map("getSpreadOfLeg2Notation", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Notation()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getFloatingRateDayCountConventionOfLeg2", jFSATransactionReport -> jFSATransactionReport.getFloatingRateDayCountConventionOfLeg2()).map("to-string", InterestComputationMethod4Code::toDisplayString).get(), MapperS.of(drrReport).<String>map("getFloatingRatePaymentFrequencyPeriodLeg2", jFSATransactionReport -> jFSATransactionReport.getFloatingRatePaymentFrequencyPeriodLeg2()).map("to-string", Object::toString).get(), MapperS.of(drrReport).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplierLeg2", jFSATransactionReport -> jFSATransactionReport.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()).get(), MapperS.of(drrReport).<String>map("getFloatingRateResetFrequencyPeriodOfLeg2", jFSATransactionReport -> jFSATransactionReport.getFloatingRateResetFrequencyPeriodOfLeg2()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateResetFrequencyPeriodMultiplierLeg2", jFSATransactionReport -> jFSATransactionReport.getFloatingRateResetFrequencyPeriodMultiplierLeg2()).get()));
			
			return Optional.ofNullable(fltg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
