package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsVarianceSwap;
import drr.regulation.common.functions.IsVolatilitySwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.reports.CDEStrikePriceNotationEnumRule;
import drr.standards.iso.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetStrikePriceNotationEnumRule.GetStrikePriceNotationEnumRuleDefault.class)
public abstract class GetStrikePriceNotationEnumRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceNotationEnumRule cDEStrikePriceNotationEnumRule;
	@Inject protected IsVarianceSwap isVarianceSwap;
	@Inject protected IsVolatilitySwap isVolatilitySwap;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class GetStrikePriceNotationEnumRuleDefault extends GetStrikePriceNotationEnumRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			if (areEqual(MapperS.of(cDEStrikePriceNotationEnumRule.evaluate(input)), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
				output = PriceNotationEnum.DECIMAL;
			} else if (areEqual(MapperS.of(cDEStrikePriceNotationEnumRule.evaluate(input)), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).and(ComparisonResult.of(MapperS.of(isVarianceSwap.evaluate(productForEvent.evaluate(input)))).or(ComparisonResult.of(MapperS.of(isVolatilitySwap.evaluate(productForEvent.evaluate(input)))))).getOrDefault(false)) {
				output = PriceNotationEnum.DECIMAL;
			} else {
				output = cDEStrikePriceNotationEnumRule.evaluate(input);
			}
			
			return output;
		}
	}
}
