package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsEquity;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.standards.iosco.cde.reports.CDEQuantityUnitOfMeasureRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(QuantityUnitOfMeasureLeg2Rule.QuantityUnitOfMeasureLeg2RuleDefault.class)
public abstract class QuantityUnitOfMeasureLeg2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEQuantityUnitOfMeasureRule cDEQuantityUnitOfMeasureRule;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsEquity isEquity;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class QuantityUnitOfMeasureLeg2RuleDefault extends QuantityUnitOfMeasureLeg2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperC<NonNegativeQuantitySchedule> thenArg2 = thenArg1
				.mapSingleToList(item -> {
					final Boolean _boolean = isCommoditySwap.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get())))).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue());
					}
					if (ComparisonResult.of(MapperS.of(isEquity.evaluate(productForTrade.evaluate(item.get())))).and(exists(MapperS.of(interestRateLeg2.evaluate(productForTrade.evaluate(item.get()))).<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()))).getOrDefault(false)) {
						return MapperC.of(MapperS.of(interestRateLeg2.evaluate(productForTrade.evaluate(item.get()))).<ResolvablePriceQuantity>map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()));
					}
					return MapperC.<NonNegativeQuantitySchedule>ofNull();
				});
			final MapperC<String> thenArg3 = thenArg2
				.mapItem(item -> MapperS.of(cDEQuantityUnitOfMeasureRule.evaluate(item.get())));
			output = thenArg3
				.last().get();
			
			return output;
		}
	}
}
