package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1013_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1013_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1013_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1013_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> TERM to-string, ActionTypeEnum -> PRTO to-string, ActionTypeEnum -> VALU to-string ] any = actionType then (executionAgentOfCounterparty1 <> counterparty1 or executionAgentOfCounterparty1 <> counterparty2 or executionAgentOfCounterparty1 <> reportingEntity) and (if executionAgentOfCounterparty1 = \"NOAP\" then executionAgentOfCounterparty2DTCC exists)";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1013_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult;
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of("NOAP"), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult = exists(MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentOfCounterparty2DTCC", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentOfCounterparty2DTCC()));
					} else {
						ifThenElseResult = ComparisonResult.successEmptyOperand("");
					}
					return notEqual(MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of(aSICTransactionReport).<String>map("getCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getCounterparty1()), CardinalityOperator.Any).or(notEqual(MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of(aSICTransactionReport).<String>map("getCounterparty2", _aSICTransactionReport -> _aSICTransactionReport.getCounterparty2()), CardinalityOperator.Any)).or(notEqual(MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentOfCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentOfCounterparty1()), MapperS.of(aSICTransactionReport).<String>map("getReportingEntity", _aSICTransactionReport -> _aSICTransactionReport.getReportingEntity()), CardinalityOperator.Any)).and(ifThenElseResult);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1013_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
