package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICNonReportable;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.common.ActionTypeEnum;
import drr.standards.iso.upi.AnnaDsbDerived;
import drr.standards.iso.upi.AnnaDsbHeader;
import drr.standards.iso.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iso.upi.AnnaDsbUpiRecord;
import drr.standards.iso.upi.AnnaDsbValuationMethodorTriggerEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1059_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1059_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1059_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1059_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and [\"OPTN\", \"SWPT\"] any = contractType then if (nonReportable -> postUpiData -> Header -> InstrumentType = AnnaDsbInstrumentTypeEnum -> Option and (nonReportable -> postUpiData -> Derived -> ValuationMethodorTrigger <> AnnaDsbValuationMethodorTriggerEnum -> Barrier or nonReportable -> postUpiData -> Derived -> ValuationMethodorTrigger <> AnnaDsbValuationMethodorTriggerEnum -> Digital_Barrier)) then strikePrice -> strikePriceMonetary exists or strikePrice -> strikePriceDecimal exists";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1059_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperC.<String>of(MapperS.of("OPTN"), MapperS.of("SWPT")), MapperS.of(aSICTransactionReport).<String>map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), CardinalityOperator.Any)).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbHeader>map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).<AnnaDsbInstrumentTypeEnum>map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), MapperS.of(AnnaDsbInstrumentTypeEnum.OPTION), CardinalityOperator.All).and(notEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbDerived>map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).<AnnaDsbValuationMethodorTriggerEnum>map("getValuationMethodorTrigger", annaDsbDerived -> annaDsbDerived.getValuationMethodorTrigger()), MapperS.of(AnnaDsbValuationMethodorTriggerEnum.BARRIER), CardinalityOperator.Any).or(notEqual(MapperS.of(aSICTransactionReport).<ASICNonReportable>map("getNonReportable", _aSICTransactionReport -> _aSICTransactionReport.getNonReportable()).<AnnaDsbUpiRecord>map("getPostUpiData", aSICNonReportable -> aSICNonReportable.getPostUpiData()).<AnnaDsbDerived>map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).<AnnaDsbValuationMethodorTriggerEnum>map("getValuationMethodorTrigger", annaDsbDerived -> annaDsbDerived.getValuationMethodorTrigger()), MapperS.of(AnnaDsbValuationMethodorTriggerEnum.DIGITAL_BARRIER), CardinalityOperator.Any))).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<StrikePriceAndNotation>map("getStrikePrice", _aSICTransactionReport -> _aSICTransactionReport.getStrikePrice()).<BigDecimal>map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary())).or(exists(MapperS.of(aSICTransactionReport).<StrikePriceAndNotation>map("getStrikePrice", _aSICTransactionReport -> _aSICTransactionReport.getStrikePrice()).<BigDecimal>map("getStrikePriceDecimal", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceDecimal())));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1059_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
