package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1070_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1070_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1070_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1070_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and [\"CRDT\", \"EQUI\", \"COMM\", \"INTR\"] any = assetClass and [\"FRAS\", \"OPTN\", \"SWAP\", \"SWPT\", \"OTHR\"] any = contractType then if [\"YEAR\", \"MNTH\", \"WEEK\", \"DAIL\", \"EXPI\"] any = paymentFrequencyPeriodLeg1 then paymentFrequencyPeriodMultiplierLeg1 exists and (paymentFrequencyPeriodMultiplierLeg1 < 1000 and paymentFrequencyPeriodMultiplierLeg1 > 0) else if paymentFrequencyPeriodLeg1 = \"EXPI\" then paymentFrequencyPeriodMultiplierLeg1 = 1 else if paymentFrequencyPeriodLeg1 is absent or paymentFrequencyPeriodLeg1 = \"ADHO\" then paymentFrequencyPeriodMultiplierLeg1 is absent";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1070_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).and(areEqual(MapperC.<String>of(MapperS.of("CRDT"), MapperS.of("EQUI"), MapperS.of("COMM"), MapperS.of("INTR")), MapperS.of(aSICTransactionReport).<String>map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), CardinalityOperator.Any)).and(areEqual(MapperC.<String>of(MapperS.of("FRAS"), MapperS.of("OPTN"), MapperS.of("SWAP"), MapperS.of("SWPT"), MapperS.of("OTHR")), MapperS.of(aSICTransactionReport).<String>map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), CardinalityOperator.Any)).getOrDefault(false)) {
					if (areEqual(MapperC.<String>of(MapperS.of("YEAR"), MapperS.of("MNTH"), MapperS.of("WEEK"), MapperS.of("DAIL"), MapperS.of("EXPI")), MapperS.of(aSICTransactionReport).<String>map("getPaymentFrequencyPeriodLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodLeg1()), CardinalityOperator.Any).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg1())).and(lessThan(MapperS.of(aSICTransactionReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg1()), MapperS.of(1000), CardinalityOperator.All).and(greaterThan(MapperS.of(aSICTransactionReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg1()), MapperS.of(0), CardinalityOperator.All)));
					}
					if (areEqual(MapperS.of(aSICTransactionReport).<String>map("getPaymentFrequencyPeriodLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodLeg1()), MapperS.of("EXPI"), CardinalityOperator.All).getOrDefault(false)) {
						return areEqual(MapperS.of(aSICTransactionReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg1()), MapperS.of(1), CardinalityOperator.All);
					}
					if (notExists(MapperS.of(aSICTransactionReport).<String>map("getPaymentFrequencyPeriodLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodLeg1())).or(areEqual(MapperS.of(aSICTransactionReport).<String>map("getPaymentFrequencyPeriodLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodLeg1()), MapperS.of("ADHO"), CardinalityOperator.All)).getOrDefault(false)) {
						return notExists(MapperS.of(aSICTransactionReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg1", _aSICTransactionReport -> _aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg1()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1070_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
