package drr.regulation.asic.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.PackageTransactionPrice;
import drr.regulation.common.ActionTypeEnum;
import drr.standards.iso.PriceNotationEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1095_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1095_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1095_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1095_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType then if packageTransactionPrice -> packageTransactionPriceNotation = PriceNotationEnum -> Monetary then packageTransactionPrice -> packageTransactionPriceCurrency exists and [ISOCurrencyCodeEnum -> XAG, ISOCurrencyCodeEnum -> XAU, ISOCurrencyCodeEnum -> XBA, ISOCurrencyCodeEnum -> XBB, ISOCurrencyCodeEnum -> XBC, ISOCurrencyCodeEnum -> XBD, ISOCurrencyCodeEnum -> XDR, ISOCurrencyCodeEnum -> XPD, ISOCurrencyCodeEnum -> XPT, ISOCurrencyCodeEnum -> XTS] any <> packageTransactionPrice -> packageTransactionPriceCurrency else if packageTransactionPrice -> packageTransactionPriceNotation = PriceNotationEnum -> Decimal then packageTransactionPrice -> packageTransactionPriceCurrency is absent";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1095_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(aSICTransactionReport).<String>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (areEqual(MapperS.of(aSICTransactionReport).<PackageTransactionPrice>map("getPackageTransactionPrice", _aSICTransactionReport -> _aSICTransactionReport.getPackageTransactionPrice()).<PriceNotationEnum>map("getPackageTransactionPriceNotation", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
						return exists(MapperS.of(aSICTransactionReport).<PackageTransactionPrice>map("getPackageTransactionPrice", _aSICTransactionReport -> _aSICTransactionReport.getPackageTransactionPrice()).<ISOCurrencyCodeEnum>map("getPackageTransactionPriceCurrency", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceCurrency())).and(notEqual(MapperC.<ISOCurrencyCodeEnum>of(MapperS.of(ISOCurrencyCodeEnum.XAG), MapperS.of(ISOCurrencyCodeEnum.XAU), MapperS.of(ISOCurrencyCodeEnum.XBA), MapperS.of(ISOCurrencyCodeEnum.XBB), MapperS.of(ISOCurrencyCodeEnum.XBC), MapperS.of(ISOCurrencyCodeEnum.XBD), MapperS.of(ISOCurrencyCodeEnum.XDR), MapperS.of(ISOCurrencyCodeEnum.XPD), MapperS.of(ISOCurrencyCodeEnum.XPT), MapperS.of(ISOCurrencyCodeEnum.XTS)), MapperS.of(aSICTransactionReport).<PackageTransactionPrice>map("getPackageTransactionPrice", _aSICTransactionReport -> _aSICTransactionReport.getPackageTransactionPrice()).<ISOCurrencyCodeEnum>map("getPackageTransactionPriceCurrency", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceCurrency()), CardinalityOperator.Any));
					}
					if (areEqual(MapperS.of(aSICTransactionReport).<PackageTransactionPrice>map("getPackageTransactionPrice", _aSICTransactionReport -> _aSICTransactionReport.getPackageTransactionPrice()).<PriceNotationEnum>map("getPackageTransactionPriceNotation", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
						return notExists(MapperS.of(aSICTransactionReport).<PackageTransactionPrice>map("getPackageTransactionPrice", _aSICTransactionReport -> _aSICTransactionReport.getPackageTransactionPrice()).<ISOCurrencyCodeEnum>map("getPackageTransactionPriceCurrency", packageTransactionPrice -> packageTransactionPrice.getPackageTransactionPriceCurrency()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1095_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
