package drr.regulation.asic.rewrite.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.Basket;
import drr.regulation.asic.rewrite.trade.BasketConstituentsReport;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class BasketOnlyExistsValidator implements ValidatorWithArg<Basket, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends Basket> ValidationResult<Basket> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("basketConstituents", ExistenceChecker.isSet((List<? extends BasketConstituentsReport>) o.getBasketConstituents()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("Basket", ValidationResult.ValidationType.ONLY_EXISTS, "Basket", path, "");
		}
		return failure("Basket", ValidationResult.ValidationType.ONLY_EXISTS, "Basket", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
