package drr.regulation.cftc.rewrite.reports;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.common.Instruction;
import cdm.event.common.Trade;
import cdm.event.common.TradeIdentifier;
import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.ClearingSwapUSIsReport;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FindLatestAssignedIdentifier;
import drr.regulation.common.functions.IntendedToClear;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsCleared;
import drr.standards.iosco.cde.reports.CDEEventTypeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ClearingSwapUSIsRule.ClearingSwapUSIsRuleDefault.class)
public abstract class ClearingSwapUSIsRule implements ReportFunction<TransactionReportInstruction, List<? extends ClearingSwapUSIsReport>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEEventTypeRule cDEEventTypeRule;
	@Inject protected ClearingSwapUSIRule clearingSwapUSIRule;
	@Inject protected FindLatestAssignedIdentifier findLatestAssignedIdentifier;
	@Inject protected IntendedToClear intendedToClear;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsCleared isCleared;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends ClearingSwapUSIsReport> evaluate(TransactionReportInstruction input) {
		List<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends ClearingSwapUSIsReport> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(ClearingSwapUSIsReport::build).collect(Collectors.toList());
			objectValidator.validate(ClearingSwapUSIsReport.class, output);
		}
		
		return output;
	}

	protected abstract List<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class ClearingSwapUSIsRuleDefault extends ClearingSwapUSIsRule {
		@Override
		protected List<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> assignOutput(List<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<BusinessEvent> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (ComparisonResult.of(MapperS.of(isCleared.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get()))).or(ComparisonResult.of(MapperS.of(intendedToClear.evaluate(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get()))).and(ComparisonResult.of(MapperS.of(isActionTypeTERM.evaluate(item.get()))))).and(areEqual(MapperS.of(cDEEventTypeRule.evaluate(item.get())), MapperS.of("CLRG"), CardinalityOperator.All)).getOrDefault(false)) {
						return item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent());
					}
					return MapperS.<BusinessEvent>ofNull();
				});
			final MapperC<AssignedIdentifier> thenArg1 = thenArg0
				.mapSingleToList(businessEvent -> {
					final MapperC<TradeIdentifier> _thenArg0 = businessEvent.<TradeState>mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier())
						.filterItemNullSafe(item -> notEqual(businessEvent.<Instruction>mapC("getInstruction", _businessEvent -> _businessEvent.getInstruction()).<ReferenceWithMetaTradeState>map("getBefore", instruction -> instruction.getBefore()).<TradeState>map("Type coercion", referenceWithMetaTradeState -> referenceWithMetaTradeState.getValue()).<Trade>map("getTrade", tradeState -> tradeState.getTrade()).<TradeIdentifier>mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()), item, CardinalityOperator.All).get());
					final MapperC<TradeIdentifier> _thenArg1 = _thenArg0
						.filterItemNullSafe(item -> areEqual(item.<TradeIdentifierTypeEnum>map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), MapperS.of(TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER), CardinalityOperator.All).get());
					return _thenArg1
						.mapItem(item -> MapperS.of(findLatestAssignedIdentifier.evaluate(item.get())));
				});
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(ClearingSwapUSIsReport.builder()
					.setIdentifier(clearingSwapUSIRule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
