package drr.regulation.cftc.rewrite.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CFTCFinancialEntityClassificationEnum;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCleared;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Counterparty1FinancialEntityIndicatorRule.Counterparty1FinancialEntityIndicatorRuleDefault.class)
public abstract class Counterparty1FinancialEntityIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCleared isCleared;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class Counterparty1FinancialEntityIndicatorRuleDefault extends Counterparty1FinancialEntityIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(reportInstruction -> {
					final MapperC<PartyInformation> thenArg0;
					if (areEqual(MapperS.of(isCleared.evaluate(reportInstruction.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
						thenArg0 = reportInstruction.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
							.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), reportInstruction.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), CardinalityOperator.All).get());
					} else {
						thenArg0 = MapperC.<PartyInformation>ofNull();
					}
					final MapperS<PartyInformation> thenArg1 = MapperS.of(thenArg0.get());
					return thenArg1
						.mapSingleToItem(item -> {
							if (exists(item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<CFTCFinancialEntityClassificationEnum>map("getFinancialEntity", cFTCPartyInformation -> cFTCPartyInformation.getFinancialEntity())).getOrDefault(false)) {
								return MapperS.of(true);
							}
							return MapperS.of(false);
						});
				}).get();
			
			return output;
		}
	}
}
