package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalAmountScheduleEffectiveDateRule;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountScheduleLeg1EffectiveDateRule.NotionalAmountScheduleLeg1EffectiveDateRuleDefault.class)
public abstract class NotionalAmountScheduleLeg1EffectiveDateRule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalAmountScheduleEffectiveDateRule cDENotionalAmountScheduleEffectiveDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class NotionalAmountScheduleLeg1EffectiveDateRuleDefault extends NotionalAmountScheduleLeg1EffectiveDateRule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalAmountScheduleEffectiveDateRule.evaluate(input);
			
			return output;
		}
	}
}
