package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.Trade;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.FrequencyPeriod;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.QuantityFrequencyOrCalculationPeriod;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;


@ImplementedBy(QuantityFrequencyLeg2Rule.QuantityFrequencyLeg2RuleDefault.class)
public abstract class QuantityFrequencyLeg2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected FrequencyPeriod frequencyPeriod;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected QuantityFrequencyOrCalculationPeriod quantityFrequencyOrCalculationPeriod;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class QuantityFrequencyLeg2RuleDefault extends QuantityFrequencyLeg2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCommoditySwap.evaluate(productForTrade.evaluate(item.get()));
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(frequencyPeriod.evaluate(commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get()))), quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(item.get()))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get()))))));
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
