package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.Trade;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.functions.FormatToMax3Number;
import drr.regulation.common.functions.FrequencyPeriodMultiplier;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.QuantityFrequencyOrCalculationPeriod;
import drr.regulation.common.functions.TradeForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(QuantityFrequencyMultiplierLeg2Rule.QuantityFrequencyMultiplierLeg2RuleDefault.class)
public abstract class QuantityFrequencyMultiplierLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected FormatToMax3Number formatToMax3Number;
	@Inject protected FrequencyPeriodMultiplier frequencyPeriodMultiplier;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected QuantityFrequencyOrCalculationPeriod quantityFrequencyOrCalculationPeriod;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class QuantityFrequencyMultiplierLeg2RuleDefault extends QuantityFrequencyMultiplierLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<Integer> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final Boolean _boolean = isCommoditySwap.evaluate(productForTrade.evaluate(item.get()));
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of(frequencyPeriodMultiplier.evaluate(quantityFrequencyOrCalculationPeriod.evaluate(MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(item.get()))).<CalculationPeriodDates>map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).get(), commodityObservablePriceQuantity.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(item.get()))))));
					}
					return MapperS.<Integer>ofNull();
				});
			final Integer integer = thenArg1.get();
			output = MapperS.of(formatToMax3Number.evaluate((integer == null ? null : BigDecimal.valueOf(integer)))).get();
			
			return output;
		}
	}
}
