package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("CFTCPart43TransactionReportQuantityUnitOfMeasureCondition")
@ImplementedBy(CFTCPart43TransactionReportQuantityUnitOfMeasureCondition.Default.class)
public interface CFTCPart43TransactionReportQuantityUnitOfMeasureCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportQuantityUnitOfMeasureCondition";
	String DEFINITION = "if [\"Commodity\", \"Equity\"] any = cftcGuidebook -> assetClass then quantityUnitOfMeasureLeg1 exists or quantityUnitOfMeasureLeg2 exists else quantityUnitOfMeasureLeg1 is absent and quantityUnitOfMeasureLeg2 is absent";
	
	class Default implements CFTCPart43TransactionReportQuantityUnitOfMeasureCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of("Commodity"), MapperS.of("Equity")), MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityUnitOfMeasureLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityUnitOfMeasureLeg1())).or(exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityUnitOfMeasureLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityUnitOfMeasureLeg2())));
				}
				return notExists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityUnitOfMeasureLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityUnitOfMeasureLeg1())).and(notExists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityUnitOfMeasureLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityUnitOfMeasureLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportQuantityUnitOfMeasureCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
