package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.ClearingSwapUSIsReport;
import drr.regulation.cftc.rewrite.ClearingSwapUTIsReport;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("CFTCPart45TransactionReportClearingSwapUTICondition")
@ImplementedBy(CFTCPart45TransactionReportClearingSwapUTICondition.Default.class)
public interface CFTCPart45TransactionReportClearingSwapUTICondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportClearingSwapUTICondition";
	String DEFINITION = "if (cleared = \"Y\" or (cleared = \"I\" and actionType = ActionTypeEnum -> TERM to-string)) and eventType = EventTypeEnum -> CLRG to-string then (if clearingSwapUTIs is absent then clearingSwapUSIs exists else if clearingSwapUTIs exists then clearingSwapUSIs is absent) else clearingSwapUTIs is absent";
	
	class Default implements CFTCPart45TransactionReportClearingSwapUTICondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getCleared", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCleared()), MapperS.of("Y"), CardinalityOperator.All).or(areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getCleared", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCleared()), MapperS.of("I"), CardinalityOperator.All).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getActionType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getActionType()), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All))).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<String>map("getEventType", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getEventType()), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), CardinalityOperator.All)).getOrDefault(false)) {
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<ClearingSwapUTIsReport>mapC("getClearingSwapUTIs", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getClearingSwapUTIs())).getOrDefault(false)) {
						return exists(MapperS.of(cFTCPart45TransactionReport).<ClearingSwapUSIsReport>mapC("getClearingSwapUSIs", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getClearingSwapUSIs()));
					}
					if (exists(MapperS.of(cFTCPart45TransactionReport).<ClearingSwapUTIsReport>mapC("getClearingSwapUTIs", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getClearingSwapUTIs())).getOrDefault(false)) {
						return notExists(MapperS.of(cFTCPart45TransactionReport).<ClearingSwapUSIsReport>mapC("getClearingSwapUSIs", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getClearingSwapUSIs()));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<ClearingSwapUTIsReport>mapC("getClearingSwapUTIs", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getClearingSwapUTIs()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportClearingSwapUTICondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
