package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("CFTCPart45TransactionReportReceiverIdentifierCondition")
@ImplementedBy(CFTCPart45TransactionReportReceiverIdentifierCondition.Default.class)
public interface CFTCPart45TransactionReportReceiverIdentifierCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportReceiverIdentifierCondition";
	String DEFINITION = "if buyerIdentifier is absent and sellerIdentifier is absent then ((if receiverIdentifierLeg1 exists then [counterparty1, counterparty2] any = receiverIdentifierLeg1) and (if receiverIdentifierLeg2 exists then [counterparty1, counterparty2] any = receiverIdentifierLeg2)) else receiverIdentifierLeg1 is absent and receiverIdentifierLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportReceiverIdentifierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getBuyerIdentifier", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getBuyerIdentifier())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getSellerIdentifier", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSellerIdentifier()))).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getReceiverIdentifierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg1())).getOrDefault(false)) {
						ifThenElseResult0 = areEqual(MapperC.<String>of(MapperS.of(cFTCPart45TransactionReport).<String>map("getCounterparty1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCounterparty1()), MapperS.of(cFTCPart45TransactionReport).<String>map("getCounterparty2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCounterparty2())), MapperS.of(cFTCPart45TransactionReport).<String>map("getReceiverIdentifierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg1()), CardinalityOperator.Any);
					} else {
						ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<String>map("getReceiverIdentifierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg2())).getOrDefault(false)) {
						ifThenElseResult1 = areEqual(MapperC.<String>of(MapperS.of(cFTCPart45TransactionReport).<String>map("getCounterparty1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCounterparty1()), MapperS.of(cFTCPart45TransactionReport).<String>map("getCounterparty2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCounterparty2())), MapperS.of(cFTCPart45TransactionReport).<String>map("getReceiverIdentifierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg2()), CardinalityOperator.Any);
					} else {
						ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
					}
					return ifThenElseResult0.and(ifThenElseResult1);
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getReceiverIdentifierLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg1())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<String>map("getReceiverIdentifierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportReceiverIdentifierCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
