package drr.regulation.cftc.rewrite.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CFTCGuidebookPart45OnlyExistsValidator implements ValidatorWithArg<CFTCGuidebookPart45, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CFTCGuidebookPart45> ValidationResult<CFTCGuidebookPart45> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("optionType", ExistenceChecker.isSet((String) o.getOptionType()))
				.put("optionStyle", ExistenceChecker.isSet((String) o.getOptionStyle()))
				.put("assetClass", ExistenceChecker.isSet((String) o.getAssetClass()))
				.put("mandatoryClearingIndicator", ExistenceChecker.isSet((Boolean) o.getMandatoryClearingIndicator()))
				.put("maturityDateOfTheUnderlier", ExistenceChecker.isSet((Date) o.getMaturityDateOfTheUnderlier()))
				.put("largeNotionalOffFacilitySwapElectionIndicator", ExistenceChecker.isSet((Boolean) o.getLargeNotionalOffFacilitySwapElectionIndicator()))
				.put("sefOrDcmIndicator", ExistenceChecker.isSet((Boolean) o.getSefOrDcmIndicator()))
				.put("sefOrDcmAnonymousExecutionIndicator", ExistenceChecker.isSet((Boolean) o.getSefOrDcmAnonymousExecutionIndicator()))
				.put("messageType", ExistenceChecker.isSet((String) o.getMessageType()))
				.put("settlementType", ExistenceChecker.isSet((String) o.getSettlementType()))
				.put("sdMspIndicatorParty1", ExistenceChecker.isSet((Boolean) o.getSdMspIndicatorParty1()))
				.put("sdMspIndicatorParty2", ExistenceChecker.isSet((Boolean) o.getSdMspIndicatorParty2()))
				.put("physicalCommodityIndicator", ExistenceChecker.isSet((Boolean) o.getPhysicalCommodityIndicator()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CFTCGuidebookPart45", ValidationResult.ValidationType.ONLY_EXISTS, "CFTCGuidebookPart45", path, "");
		}
		return failure("CFTCGuidebookPart45", ValidationResult.ValidationType.ONLY_EXISTS, "CFTCGuidebookPart45", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
