package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.CollateralReportInstructionMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Specifies a reportable collateral with with a single reporting side.
 * @version 5.52.0
 */
@RosettaDataType(value="CollateralReportInstruction", builder=CollateralReportInstruction.CollateralReportInstructionBuilderImpl.class, version="5.52.0")
@RuneDataType(value="CollateralReportInstruction", model="drr", builder=CollateralReportInstruction.CollateralReportInstructionBuilderImpl.class, version="5.52.0")
public interface CollateralReportInstruction extends ReportableCollateral {

	CollateralReportInstructionMeta metaData = new CollateralReportInstructionMeta();

	/*********************** Getter Methods  ***********************/
	ReportingSide getReportingSide();

	/*********************** Build Methods  ***********************/
	CollateralReportInstruction build();
	
	CollateralReportInstruction.CollateralReportInstructionBuilder toBuilder();
	
	static CollateralReportInstruction.CollateralReportInstructionBuilder builder() {
		return new CollateralReportInstruction.CollateralReportInstructionBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CollateralReportInstruction> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CollateralReportInstruction> getType() {
		return CollateralReportInstruction.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.class, getCollateralDetails());
		processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, getReportableInformation());
		processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, getReportingSide());
	}
	

	/*********************** Builder Interface  ***********************/
	interface CollateralReportInstructionBuilder extends CollateralReportInstruction, ReportableCollateral.ReportableCollateralBuilder {
		ReportingSide.ReportingSideBuilder getOrCreateReportingSide();
		@Override
		ReportingSide.ReportingSideBuilder getReportingSide();
		@Override
		CollateralReportInstruction.CollateralReportInstructionBuilder setCollateralDetails(CollateralDetails collateralDetails);
		@Override
		CollateralReportInstruction.CollateralReportInstructionBuilder setReportableInformation(ReportableInformation reportableInformation);
		CollateralReportInstruction.CollateralReportInstructionBuilder setReportingSide(ReportingSide reportingSide);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.CollateralDetailsBuilder.class, getCollateralDetails());
			processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, getReportableInformation());
			processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, getReportingSide());
		}
		

		CollateralReportInstruction.CollateralReportInstructionBuilder prune();
	}

	/*********************** Immutable Implementation of CollateralReportInstruction  ***********************/
	class CollateralReportInstructionImpl extends ReportableCollateral.ReportableCollateralImpl implements CollateralReportInstruction {
		private final ReportingSide reportingSide;
		
		protected CollateralReportInstructionImpl(CollateralReportInstruction.CollateralReportInstructionBuilder builder) {
			super(builder);
			this.reportingSide = ofNullable(builder.getReportingSide()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="reportingSide", isRequired=true)
		@RuneAttribute(value="reportingSide", isRequired=true)
		public ReportingSide getReportingSide() {
			return reportingSide;
		}
		
		@Override
		public CollateralReportInstruction build() {
			return this;
		}
		
		@Override
		public CollateralReportInstruction.CollateralReportInstructionBuilder toBuilder() {
			CollateralReportInstruction.CollateralReportInstructionBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CollateralReportInstruction.CollateralReportInstructionBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getReportingSide()).ifPresent(builder::setReportingSide);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CollateralReportInstruction _that = getType().cast(o);
		
			if (!Objects.equals(reportingSide, _that.getReportingSide())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportingSide != null ? reportingSide.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CollateralReportInstruction {" +
				"reportingSide=" + this.reportingSide +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of CollateralReportInstruction  ***********************/
	class CollateralReportInstructionBuilderImpl extends ReportableCollateral.ReportableCollateralBuilderImpl implements CollateralReportInstruction.CollateralReportInstructionBuilder {
	
		protected ReportingSide.ReportingSideBuilder reportingSide;
		
		@Override
		@RosettaAttribute(value="reportingSide", isRequired=true)
		@RuneAttribute(value="reportingSide", isRequired=true)
		public ReportingSide.ReportingSideBuilder getReportingSide() {
			return reportingSide;
		}
		
		@Override
		public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
			ReportingSide.ReportingSideBuilder result;
			if (reportingSide!=null) {
				result = reportingSide;
			}
			else {
				result = reportingSide = ReportingSide.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("collateralDetails")
		@RuneAttribute("collateralDetails")
		@Override
		public CollateralReportInstruction.CollateralReportInstructionBuilder setCollateralDetails(CollateralDetails _collateralDetails) {
			this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		@Override
		public CollateralReportInstruction.CollateralReportInstructionBuilder setReportableInformation(ReportableInformation _reportableInformation) {
			this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="reportingSide", isRequired=true)
		@RuneAttribute(value="reportingSide", isRequired=true)
		@Override
		public CollateralReportInstruction.CollateralReportInstructionBuilder setReportingSide(ReportingSide _reportingSide) {
			this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
			return this;
		}
		
		@Override
		public CollateralReportInstruction build() {
			return new CollateralReportInstruction.CollateralReportInstructionImpl(this);
		}
		
		@Override
		public CollateralReportInstruction.CollateralReportInstructionBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CollateralReportInstruction.CollateralReportInstructionBuilder prune() {
			super.prune();
			if (reportingSide!=null && !reportingSide.prune().hasData()) reportingSide = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getReportingSide()!=null && getReportingSide().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CollateralReportInstruction.CollateralReportInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			CollateralReportInstruction.CollateralReportInstructionBuilder o = (CollateralReportInstruction.CollateralReportInstructionBuilder) other;
			
			merger.mergeRosetta(getReportingSide(), o.getReportingSide(), this::setReportingSide);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CollateralReportInstruction _that = getType().cast(o);
		
			if (!Objects.equals(reportingSide, _that.getReportingSide())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (reportingSide != null ? reportingSide.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CollateralReportInstructionBuilder {" +
				"reportingSide=" + this.reportingSide +
			'}' + " " + super.toString();
		}
	}
}
