package drr.regulation.common.functions;

import cdm.base.datetime.PeriodEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FloatingReferencePeriod.FloatingReferencePeriodDefault.class)
public abstract class FloatingReferencePeriod implements RosettaFunction {

	/**
	* @param period 
	* @return result 
	*/
	public String evaluate(PeriodEnum period) {
		String result = doEvaluate(period);
		
		return result;
	}

	protected abstract String doEvaluate(PeriodEnum period);

	public static class FloatingReferencePeriodDefault extends FloatingReferencePeriod {
		@Override
		protected String doEvaluate(PeriodEnum period) {
			String result = null;
			return assignOutput(result, period);
		}
		
		protected String assignOutput(String result, PeriodEnum period) {
			if (areEqual(MapperS.of(period), MapperS.of(PeriodEnum.D), CardinalityOperator.All).getOrDefault(false)) {
				result = "DAIL";
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodEnum.W), CardinalityOperator.All).getOrDefault(false)) {
				result = "WEEK";
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodEnum.M), CardinalityOperator.All).getOrDefault(false)) {
				result = "MNTH";
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodEnum.Y), CardinalityOperator.All).getOrDefault(false)) {
				result = "YEAR";
			} else {
				result = null;
			}
			
			return result;
		}
	}
}
