package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;


@ImplementedBy(GetActionType.GetActionTypeDefault.class)
public abstract class GetActionType implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsActionTypeCORR isActionTypeCORR;
	@Inject protected IsActionTypeEROR isActionTypeEROR;
	@Inject protected IsActionTypeMODI isActionTypeMODI;
	@Inject protected IsActionTypeNEWT isActionTypeNEWT;
	@Inject protected IsActionTypePOSC isActionTypePOSC;
	@Inject protected IsActionTypePositionMODI isActionTypePositionMODI;
	@Inject protected IsActionTypeREVI isActionTypeREVI;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsActionTypeVALU isActionTypeVALU;

	/**
	* @param reportableEvent 
	* @return action 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String action = doEvaluate(reportableEvent);
		
		return action;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	public static class GetActionTypeDefault extends GetActionType {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String action = null;
			return assignOutput(action, reportableEvent);
		}
		
		protected String assignOutput(String action, ReportableEvent reportableEvent) {
			final Boolean boolean0 = isActionTypeCORR.evaluate(reportableEvent);
			if ((boolean0 == null ? false : boolean0)) {
				action = MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString).get();
			} else {
				final Boolean boolean1 = isActionTypeEROR.evaluate(reportableEvent);
				if ((boolean1 == null ? false : boolean1)) {
					action = MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString).get();
				} else {
					final Boolean boolean2 = isActionTypeREVI.evaluate(reportableEvent);
					if ((boolean2 == null ? false : boolean2)) {
						action = MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString).get();
					} else {
						final Boolean boolean3 = isActionTypeVALU.evaluate(reportableEvent);
						if ((boolean3 == null ? false : boolean3)) {
							action = MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString).get();
						} else {
							final Boolean boolean4 = isActionTypeTERM.evaluate(reportableEvent);
							if ((boolean4 == null ? false : boolean4)) {
								action = MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString).get();
							} else {
								final Boolean boolean5 = isActionTypeMODI.evaluate(reportableEvent);
								if ((boolean5 == null ? false : boolean5)) {
									action = MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString).get();
								} else {
									final Boolean boolean6 = isActionTypePositionMODI.evaluate(reportableEvent);
									if ((boolean6 == null ? false : boolean6)) {
										action = MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString).get();
									} else {
										final Boolean boolean7 = isActionTypePOSC.evaluate(reportableEvent);
										if ((boolean7 == null ? false : boolean7)) {
											action = MapperS.of(ActionTypeEnum.POSC).map("to-string", ActionTypeEnum::toDisplayString).get();
										} else {
											final Boolean boolean8 = isActionTypeNEWT.evaluate(reportableEvent);
											if ((boolean8 == null ? false : boolean8)) {
												action = MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString).get();
											} else {
												action = "ToDo";
											}
										}
									}
								}
							}
						}
					}
				}
			}
			
			return action;
		}
	}
}
