package drr.regulation.common.functions;

import cdm.base.datetime.RelativeDateOffset;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.schedule.ResetDates;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetNextFloatingReferenceResetDate.GetNextFloatingReferenceResetDateDefault.class)
public abstract class GetNextFloatingReferenceResetDate implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param reportableEvent 
	* @param interestRateLeg 
	* @return nextFloatingReferenceResetDate 
	*/
	public Date evaluate(ReportableEvent reportableEvent, InterestRatePayout interestRateLeg) {
		Date nextFloatingReferenceResetDate = doEvaluate(reportableEvent, interestRateLeg);
		
		return nextFloatingReferenceResetDate;
	}

	protected abstract Date doEvaluate(ReportableEvent reportableEvent, InterestRatePayout interestRateLeg);

	public static class GetNextFloatingReferenceResetDateDefault extends GetNextFloatingReferenceResetDate {
		@Override
		protected Date doEvaluate(ReportableEvent reportableEvent, InterestRatePayout interestRateLeg) {
			Date nextFloatingReferenceResetDate = null;
			return assignOutput(nextFloatingReferenceResetDate, reportableEvent, interestRateLeg);
		}
		
		protected Date assignOutput(Date nextFloatingReferenceResetDate, ReportableEvent reportableEvent, InterestRatePayout interestRateLeg) {
			final MapperS<Product> thenArg0 = MapperS.of(productForEvent.evaluate(reportableEvent));
			final MapperS<Product> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
			final MapperS<Product> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(interestRateLeg));
			nextFloatingReferenceResetDate = thenArg3
				.mapSingleToItem(item -> {
					if (exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).and(exists(item.<ResetDates>map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()))).getOrDefault(false)) {
						return item.<ResetDates>map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).<RelativeDateOffset>map("getFixingDates", resetDates -> resetDates.getFixingDates()).<Date>map("getAdjustedDate", relativeDateOffset -> relativeDateOffset.getAdjustedDate());
					}
					if (exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate())).and(exists(item.<ResetDates>map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()))).getOrDefault(false)) {
						return item.<ResetDates>map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).<RelativeDateOffset>map("getFixingDates", resetDates -> resetDates.getFixingDates()).<Date>map("getAdjustedDate", relativeDateOffset -> relativeDateOffset.getAdjustedDate());
					}
					return MapperS.<Date>ofNull();
				}).get();
			
			return nextFloatingReferenceResetDate;
		}
	}
}
