package drr.regulation.esma.emir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.esma.emir.refit.trade.StrikePriceScheduleReport;
import drr.regulation.esma.emir.refit.trade.validation.StrikePriceScheduleReportTypeFormatValidator;
import drr.regulation.esma.emir.refit.trade.validation.StrikePriceScheduleReportValidator;
import drr.regulation.esma.emir.refit.trade.validation.datarule.StrikePriceScheduleReportMonetary;
import drr.regulation.esma.emir.refit.trade.validation.datarule.StrikePriceScheduleReportMonetaryOrPercentage;
import drr.regulation.esma.emir.refit.trade.validation.datarule.StrikePriceScheduleReportPercentage;
import drr.regulation.esma.emir.refit.trade.validation.exists.StrikePriceScheduleReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.52.0
 */
@RosettaMeta(model=StrikePriceScheduleReport.class)
public class StrikePriceScheduleReportMeta implements RosettaMetaData<StrikePriceScheduleReport> {

	@Override
	public List<Validator<? super StrikePriceScheduleReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<StrikePriceScheduleReport>create(StrikePriceScheduleReportMonetaryOrPercentage.class),
			factory.<StrikePriceScheduleReport>create(StrikePriceScheduleReportMonetary.class),
			factory.<StrikePriceScheduleReport>create(StrikePriceScheduleReportPercentage.class)
		);
	}
	
	@Override
	public List<Function<? super StrikePriceScheduleReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super StrikePriceScheduleReport> validator(ValidatorFactory factory) {
		return factory.<StrikePriceScheduleReport>create(StrikePriceScheduleReportValidator.class);
	}

	@Override
	public Validator<? super StrikePriceScheduleReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<StrikePriceScheduleReport>create(StrikePriceScheduleReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super StrikePriceScheduleReport> validator() {
		return new StrikePriceScheduleReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super StrikePriceScheduleReport> typeFormatValidator() {
		return new StrikePriceScheduleReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super StrikePriceScheduleReport, Set<String>> onlyExistsValidator() {
		return new StrikePriceScheduleReportOnlyExistsValidator();
	}
}
