package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDateSchedule;
import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.AdjustPeriod;
import drr.standards.iosco.cde.functions.MapCDEFrequencyPeriod;
import drr.standards.iosco.cde.reports.CDEPaymentFrequencyPeriodMultiplierRule;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CDEPaymentFrequencyPeriodAdjustedRule.CDEPaymentFrequencyPeriodAdjustedRuleDefault.class)
public abstract class CDEPaymentFrequencyPeriodAdjustedRule implements ReportFunction<InterestRatePayout, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustPeriod adjustPeriod;
	@Inject protected CDEPaymentFrequencyPeriodMultiplierRule cDEPaymentFrequencyPeriodMultiplierRule;
	@Inject protected MapCDEFrequencyPeriod mapCDEFrequencyPeriod;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(InterestRatePayout input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(InterestRatePayout input);

	public static class CDEPaymentFrequencyPeriodAdjustedRuleDefault extends CDEPaymentFrequencyPeriodAdjustedRule {
		@Override
		protected String doEvaluate(InterestRatePayout input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, InterestRatePayout input) {
			if (exists(MapperS.of(input).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod())).getOrDefault(false)) {
				if (areEqual(MapperS.of(input).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()), MapperS.of(PeriodExtendedEnum.C), CardinalityOperator.All).getOrDefault(false)) {
					output = adjustPeriod.evaluate(mapCDEFrequencyPeriod.evaluate(MapperS.of(input).<CalculationPeriodDates>map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).<CalculationPeriodFrequency>map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).<PeriodExtendedEnum>map("getPeriod", calculationPeriodFrequency -> calculationPeriodFrequency.getPeriod()).get()), cDEPaymentFrequencyPeriodMultiplierRule.evaluate(input));
				} else {
					output = adjustPeriod.evaluate(mapCDEFrequencyPeriod.evaluate(MapperS.of(input).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod()).get()), cDEPaymentFrequencyPeriodMultiplierRule.evaluate(input));
				}
			} else if (notExists(MapperS.of(input).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency())).and(exists(MapperS.of(input).<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<PaymentDateSchedule>map("getPaymentDateSchedule", paymentDates -> paymentDates.getPaymentDateSchedule()))).getOrDefault(false)) {
				output = "ADHO";
			} else {
				output = null;
			}
			
			return output;
		}
	}
}
