package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetBasketConstituentsProductIdentifier;
import drr.regulation.common.functions.TradeForEvent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IdentifierOfBasketConstituentsRule.IdentifierOfBasketConstituentsRuleDefault.class)
public abstract class IdentifierOfBasketConstituentsRule implements ReportFunction<TransactionReportInstruction, List<String>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetBasketConstituentsProductIdentifier getBasketConstituentsProductIdentifier;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(TransactionReportInstruction input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(TransactionReportInstruction input);

	public static class IdentifierOfBasketConstituentsRuleDefault extends IdentifierOfBasketConstituentsRule {
		@Override
		protected List<String> doEvaluate(TransactionReportInstruction input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperC<ProductIdentifier> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<ProductIdentifier>of(getBasketConstituentsProductIdentifier.evaluate(item.get())));
			output = thenArg1
				.mapItem(item -> {
					if (areEqual(item.<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All).getOrDefault(false)) {
						return item.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier());
					}
					return MapperS.<FieldWithMetaString>ofNull();
				}).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti();
			
			return output;
		}
	}
}
