package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsCapFloor;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.reports.CDEOptionPremiumAmountRule;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(OptionPremiumAmountRule.OptionPremiumAmountRuleDefault.class)
public abstract class OptionPremiumAmountRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOptionPremiumAmountRule cDEOptionPremiumAmountRule;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsCapFloor isCapFloor;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected RoundToPrecision roundToPrecision;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class OptionPremiumAmountRuleDefault extends OptionPremiumAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<BigDecimal> ifThenElseResult;
			if (exists(MapperS.of(cDEOptionPremiumAmountRule.evaluate(thenArg0.get()))).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(cDEOptionPremiumAmountRule.evaluate(thenArg0.get()));
			} else {
				final Boolean _boolean = isCapFloor.evaluate(productForEvent.evaluate(thenArg0.get()));
				if ((_boolean == null ? false : _boolean)) {
					final BigInteger bigInteger = new BigInteger("9999999999999999999999999");
					ifThenElseResult = bigInteger == null ? MapperS.<BigDecimal>ofNull() : MapperS.of(new BigDecimal(bigInteger));
				} else {
					ifThenElseResult = MapperS.<BigDecimal>ofNull();
				}
			}
			final MapperS<BigDecimal> thenArg1 = ifThenElseResult
				.mapSingleToItem(item -> MapperS.of(roundToPrecision.evaluate(item.get(), 5, RoundingDirectionEnum.NEAREST)));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
