package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2003_05")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2003_05.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2003_05 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2003_05";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then [uti, utiProprietary, reportTrackingNumber, subsequentPositionUti] all <> priorUti and [uti, utiProprietary, reportTrackingNumber, subsequentPositionUti] all <> priorUtiProprietary";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2003_05 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					return notEqual(MapperC.<String>of(MapperS.of(eSMAEMIRTransactionReport).<String>map("getUti", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUti()), MapperS.of(eSMAEMIRTransactionReport).<String>map("getUtiProprietary", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUtiProprietary()), MapperS.of(eSMAEMIRTransactionReport).<String>map("getReportTrackingNumber", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReportTrackingNumber()), MapperS.of(eSMAEMIRTransactionReport).<String>map("getSubsequentPositionUti", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSubsequentPositionUti())), MapperS.of(eSMAEMIRTransactionReport).<String>map("getPriorUti", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPriorUti()), CardinalityOperator.All).and(notEqual(MapperC.<String>of(MapperS.of(eSMAEMIRTransactionReport).<String>map("getUti", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUti()), MapperS.of(eSMAEMIRTransactionReport).<String>map("getUtiProprietary", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUtiProprietary()), MapperS.of(eSMAEMIRTransactionReport).<String>map("getReportTrackingNumber", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReportTrackingNumber()), MapperS.of(eSMAEMIRTransactionReport).<String>map("getSubsequentPositionUti", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSubsequentPositionUti())), MapperS.of(eSMAEMIRTransactionReport).<String>map("getPriorUtiProprietary", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPriorUtiProprietary()), CardinalityOperator.All));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2003_05 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
