package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2100_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2100_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2100_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2100_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if indicatorOfTheFloatingRateOfLeg2 exists then [\"ESTR\", \"SONA\", \"SOFR\", \"EONA\", \"EONS\", \"EURI\", \"EUUS\", \"EUCH\", \"GCFR\", \"ISDA\", \"LIBI\", \"LIBO\", \"MAAA\", \"PFAN\", \"TIBO\", \"STBO\", \"BBSW\", \"JIBA\", \"BUBO\", \"CDOR\", \"CIBO\", \"MOSP\", \"NIBO\", \"PRBO\", \"TLBO\", \"WIBO\", \"TREA\", \"SWAP\", \"FUSW\", \"EFFR\", \"OBFR\", \"CZNA\"] any = indicatorOfTheFloatingRateOfLeg2";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2100_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(eSMAEMIRTransactionReport).<String>map("getIndicatorOfTheFloatingRateOfLeg2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getIndicatorOfTheFloatingRateOfLeg2())).getOrDefault(false)) {
						return areEqual(MapperC.<String>of(MapperS.of("ESTR"), MapperS.of("SONA"), MapperS.of("SOFR"), MapperS.of("EONA"), MapperS.of("EONS"), MapperS.of("EURI"), MapperS.of("EUUS"), MapperS.of("EUCH"), MapperS.of("GCFR"), MapperS.of("ISDA"), MapperS.of("LIBI"), MapperS.of("LIBO"), MapperS.of("MAAA"), MapperS.of("PFAN"), MapperS.of("TIBO"), MapperS.of("STBO"), MapperS.of("BBSW"), MapperS.of("JIBA"), MapperS.of("BUBO"), MapperS.of("CDOR"), MapperS.of("CIBO"), MapperS.of("MOSP"), MapperS.of("NIBO"), MapperS.of("PRBO"), MapperS.of("TLBO"), MapperS.of("WIBO"), MapperS.of("TREA"), MapperS.of("SWAP"), MapperS.of("FUSW"), MapperS.of("EFFR"), MapperS.of("OBFR"), MapperS.of("CZNA")), MapperS.of(eSMAEMIRTransactionReport).<String>map("getIndicatorOfTheFloatingRateOfLeg2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getIndicatorOfTheFloatingRateOfLeg2()), CardinalityOperator.Any);
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2100_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
