package drr.regulation.esma.emir.refit.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg2;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2110_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2110_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2110_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2110_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if spreadOfLeg2 -> spreadOfLeg2Monetary exists then spreadOfLeg2 -> spreadCurrencyOfLeg2 exists and [ISOCurrencyCodeEnum -> XAG, ISOCurrencyCodeEnum -> XAU, ISOCurrencyCodeEnum -> XBA, ISOCurrencyCodeEnum -> XBB, ISOCurrencyCodeEnum -> XBC, ISOCurrencyCodeEnum -> XBD, ISOCurrencyCodeEnum -> XDR, ISOCurrencyCodeEnum -> XPD, ISOCurrencyCodeEnum -> XPT, ISOCurrencyCodeEnum -> XXX] all <> spreadOfLeg2 -> spreadCurrencyOfLeg2 else spreadOfLeg2 -> spreadCurrencyOfLeg2 is absent";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2110_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(eSMAEMIRTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSpreadOfLeg2()).<BigDecimal>map("getSpreadOfLeg2Monetary", spreadOfLeg2 -> spreadOfLeg2.getSpreadOfLeg2Monetary())).getOrDefault(false)) {
						return exists(MapperS.of(eSMAEMIRTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSpreadOfLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg2", spreadOfLeg2 -> spreadOfLeg2.getSpreadCurrencyOfLeg2())).and(notEqual(MapperC.<ISOCurrencyCodeEnum>of(MapperS.of(ISOCurrencyCodeEnum.XAG), MapperS.of(ISOCurrencyCodeEnum.XAU), MapperS.of(ISOCurrencyCodeEnum.XBA), MapperS.of(ISOCurrencyCodeEnum.XBB), MapperS.of(ISOCurrencyCodeEnum.XBC), MapperS.of(ISOCurrencyCodeEnum.XBD), MapperS.of(ISOCurrencyCodeEnum.XDR), MapperS.of(ISOCurrencyCodeEnum.XPD), MapperS.of(ISOCurrencyCodeEnum.XPT), MapperS.of(ISOCurrencyCodeEnum.XXX)), MapperS.of(eSMAEMIRTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSpreadOfLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg2", spreadOfLeg2 -> spreadOfLeg2.getSpreadCurrencyOfLeg2()), CardinalityOperator.All));
					}
					return notExists(MapperS.of(eSMAEMIRTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSpreadOfLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrencyOfLeg2", spreadOfLeg2 -> spreadOfLeg2.getSpreadCurrencyOfLeg2()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2110_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
