package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.PackageTransactionSpread;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2111_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2111_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2111_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2111_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) or actionType = ActionTypeEnum -> EROR to-string then if packageTransactionSpread exists then if packageTransactionSpread -> packageTransactionSpreadNotation = PriceNotationEnum -> Monetary then packageTransactionSpread -> packageTransactionSpreadMonetary exists";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2111_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				if (ComparisonResult.of(MapperS.of(isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get()))).or(areEqual(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All)).getOrDefault(false)) {
					if (exists(MapperS.of(eSMAEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPackageTransactionSpread())).getOrDefault(false)) {
						if (areEqual(MapperS.of(eSMAEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPackageTransactionSpread()).<PriceNotationEnum>map("getPackageTransactionSpreadNotation", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							return exists(MapperS.of(eSMAEMIRTransactionReport).<PackageTransactionSpread>map("getPackageTransactionSpread", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getPackageTransactionSpreadMonetary", packageTransactionSpread -> packageTransactionSpread.getPackageTransactionSpreadMonetary()));
						}
						return ComparisonResult.successEmptyOperand("");
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2111_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
