package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.eic.functions.IsAcceptedEicCode;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import iso20022.auth030.esma.EnergyLoadType1Code;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2121_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2121_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2121_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2121_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then deliveryPoint extract dp [ if IsAcceptedEicCode(dp) or IsAcceptedEicCode(interconnectionPoint) then loadType exists else loadType is absent ] then all = True";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2121_01 {
	
		@Inject protected IsAcceptedEicCode isAcceptedEicCode;
		
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				final MapperC<Boolean> thenArg;
				if ((_boolean == null ? false : _boolean)) {
					thenArg = MapperS.of(eSMAEMIRTransactionReport).<String>mapC("getDeliveryPoint", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getDeliveryPoint())
						.mapItem(dp -> {
							if (ComparisonResult.of(MapperS.of(isAcceptedEicCode.evaluate(dp.getMulti()))).or(ComparisonResult.of(MapperS.of(isAcceptedEicCode.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getInterconnectionPoint", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getInterconnectionPoint()).getMulti())))).getOrDefault(false)) {
								return exists(MapperS.of(eSMAEMIRTransactionReport).<EnergyLoadType1Code>map("getLoadType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getLoadType())).asMapper();
							}
							return notExists(MapperS.of(eSMAEMIRTransactionReport).<EnergyLoadType1Code>map("getLoadType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getLoadType())).asMapper();
						});
				} else {
					thenArg = MapperC.<Boolean>ofNull();
				}
				return ComparisonResult.of(areEqual(thenArg, MapperS.of(true), CardinalityOperator.All).asMapper());
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2121_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
