package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.PackageTransactionSpread;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("PackageTransactionSpreadBasis")
@ImplementedBy(PackageTransactionSpreadBasis.Default.class)
public interface PackageTransactionSpreadBasis extends Validator<PackageTransactionSpread> {
	
	String NAME = "PackageTransactionSpreadBasis";
	String DEFINITION = "if packageTransactionSpreadNotation = PriceNotationEnum -> Basis then packageTransactionSpreadBasis exists";
	
	class Default implements PackageTransactionSpreadBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
			ComparisonResult result = executeDataRule(packageTransactionSpread);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionSpread", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "PackageTransactionSpread", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PackageTransactionSpread packageTransactionSpread) {
			try {
				if (areEqual(MapperS.of(packageTransactionSpread).<PriceNotationEnum>map("getPackageTransactionSpreadNotation", _packageTransactionSpread -> _packageTransactionSpread.getPackageTransactionSpreadNotation()), MapperS.of(PriceNotationEnum.BASIS), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(packageTransactionSpread).<BigDecimal>map("getPackageTransactionSpreadBasis", _packageTransactionSpread -> _packageTransactionSpread.getPackageTransactionSpreadBasis()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PackageTransactionSpreadBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread packageTransactionSpread) {
			return Collections.emptyList();
		}
	}
}
