package drr.regulation.fca.ukemir.refit.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class FCAUKEMIRTradeLabelProvider extends GraphBasedLabelProvider {
	public FCAUKEMIRTradeLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "1.1 Reporting Timestamp");
		startNode.addLabel(Arrays.asList("reportSubmittingEntityID"), "1.2 Report Submitting entity ID");
		startNode.addLabel(Arrays.asList("entityResponsibleForReporting"), "1.3 Entity responsible for reporting");
		startNode.addLabel(Arrays.asList("counterparty1"), "1.4 Counterparty 1 (reporting counterparty)");
		startNode.addLabel(Arrays.asList("natureOfCounterparty1"), "1.5 Nature of the Counterparty 1");
		startNode.addLabel(Arrays.asList("corporateSectorOfTheCounterparty1"), "1.6 Corporate sector of the counterparty 1");
		startNode.addLabel(Arrays.asList("clearingThresholdOfCounterparty1"), "1.7 Clearing Threshold of Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "1.9 Counterparty 2");
		startNode.addLabel(Arrays.asList("countryOfTheCounterParty2"), "1.10 Country of the counterparty 2");
		startNode.addLabel(Arrays.asList("natureOfCounterparty2"), "1.11 Nature of the Counterparty 2");
		startNode.addLabel(Arrays.asList("corporateSectorOfTheCounterparty2"), "1.12 Corporate sector of the counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierType"), "1.8 Counterparty 2 Identifier Type");
		startNode.addLabel(Arrays.asList("clearingMember"), "1.16 Clearing member");
		startNode.addLabel(Arrays.asList("clearingThresholdOfCounterparty2"), "1.13 Clearing Threshold of Counterparty 2");
		startNode.addLabel(Arrays.asList("reportingObligationOfTheCounterparty2"), "1.14 Reporting obligation of the counterparty 2");
		startNode.addLabel(Arrays.asList("brokerID"), "1.15 Broker ID");
		startNode.addLabel(Arrays.asList("direction"), "1.17 Direction");
		startNode.addLabel(Arrays.asList("directionOfLeg1"), "1.18 Direction of leg 1");
		startNode.addLabel(Arrays.asList("directionOfLeg2"), "1.19 Direction of leg 2");
		startNode.addLabel(Arrays.asList("directlyLinkedToCommercialActivityOrTreasuryFinancing"), "1.20 Directly linked to commercial activity or treasury financing");
		startNode.addLabel(Arrays.asList("uti"), "2.1 UTI");
		startNode.addLabel(Arrays.asList("utiProprietary"), "2.1 UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("reportTrackingNumber"), "2.2 Report Tracking Number");
		startNode.addLabel(Arrays.asList("priorUTI"), "2.3 Prior UTI");
		startNode.addLabel(Arrays.asList("priorUTIProprietary"), "2.3 Prior UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("ptrrId"), "2.5 PTRR ID");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "2.6 Package identifier");
		startNode.addLabel(Arrays.asList("subsequentPositionUTI"), "2.4 Subsequent Position UTI");
		startNode.addLabel(Arrays.asList("isin"), "2.7 ISIN");
		startNode.addLabel(Arrays.asList("upi"), "2.8 UPI");
		startNode.addLabel(Arrays.asList("productClassification"), "2.9 Product classification");
		startNode.addLabel(Arrays.asList("contractType"), "2.10 Contract Type");
		startNode.addLabel(Arrays.asList("assetClass"), "2.11 Asset Class");
		startNode.addLabel(Arrays.asList("isCrypto"), "2.12 Derivative based on crypto-assets");
		startNode.addLabel(Arrays.asList("underlyingIdentificationType"), "2.13 Underlying Identification Type");
		startNode.addLabel(Arrays.asList("underlyingIdentification"), "2.14 Underlying Identification");
		startNode.addLabel(Arrays.asList("nameOfTheUnderlyingIndex"), "2.16 Name of the underlying index");
		startNode.addLabel(Arrays.asList("indicatorOfTheUnderlyingIndex"), "2.15 Indicator of the underlying index");
		startNode.addLabel(Arrays.asList("identifierOfBasketConstituents"), "2.18 Identifier of the basket's constituents");
		startNode.addLabel(Arrays.asList("customBasketCode"), "2.17 Custom basket code");
		startNode.addLabel(Arrays.asList("settlementCurrency1"), "2.19 Settlement Currency 1");
		startNode.addLabel(Arrays.asList("settlementCurrency2"), "2.20 Settlement Currency 2");
		startNode.addLabel(Arrays.asList("valuationAmount"), "2.21 Valuation amount");
		startNode.addLabel(Arrays.asList("valuationCurrency"), "2.22 Valuation currency");
		startNode.addLabel(Arrays.asList("valuationMethod"), "2.24 Valuation method");
		startNode.addLabel(Arrays.asList("delta"), "2.25 Delta");
		startNode.addLabel(Arrays.asList("valuationTimestamp"), "2.23 Valuation Timestamp");
		startNode.addLabel(Arrays.asList("confirmationTimestamp"), "2.28 Confirmation Timestamp");
		startNode.addLabel(Arrays.asList("confirmed"), "2.29 Confirmed");
		startNode.addLabel(Arrays.asList("clearingObligation"), "2.30 Clearing Obligation");
		startNode.addLabel(Arrays.asList("cleared"), "2.31 Cleared");
		startNode.addLabel(Arrays.asList("clearingTimestamp"), "2.32 Clearing Timestamp");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "2.33 Central Counterparty");
		startNode.addLabel(Arrays.asList("masterAgreementType"), "2.34 Master Agreement Type");
		startNode.addLabel(Arrays.asList("otherMasterAgreementType"), "2.35 Other Master Agreement Type");
		startNode.addLabel(Arrays.asList("masterAgreementVersion"), "2.36 Master Agreement version");
		startNode.addLabel(Arrays.asList("intragroup"), "2.37 Intragroup");
		startNode.addLabel(Arrays.asList("ptrr"), "2.38 PTRR");
		startNode.addLabel(Arrays.asList("typeOfPTRRTechnique"), "2.39 Type of PTRR technique");
		startNode.addLabel(Arrays.asList("ptrrServiceProvider"), "2.40 PTRR service provider");
		startNode.addLabel(Arrays.asList("venueOfExecution"), "2.41 Venue of Execution");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "2.42 Execution Timestamp");
		startNode.addLabel(Arrays.asList("effectiveDate"), "2.43 Effective Date");
		startNode.addLabel(Arrays.asList("expirationDate"), "2.44 Expiration Date");
		startNode.addLabel(Arrays.asList("earlyTerminationDate"), "2.45 Early termination date");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "2.46 Final Contractual Settlement Date");
		startNode.addLabel(Arrays.asList("deliveryType"), "2.47 Delivery Type");
		startNode.addLabel(Arrays.asList("notionalLeg1"), "2.55 Notional Amount 1");
		startNode.addLabel(Arrays.asList("notionalCurrency1"), "2.56 Notional Currency 1");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityLeg1"), "2.60 Total notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityLeg2"), "2.69 Total notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("notionalLeg2"), "2.64 Notional Amount 2");
		startNode.addLabel(Arrays.asList("notionalCurrency2"), "2.65 Notional Currency 2");
		startNode.addLabel(Arrays.asList("fixedRateOfLeg1"), "2.79 Fixed Rate of leg 1 or coupon");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionLeg1"), "2.80 Fixed rate or coupon day count convention leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodLeg1"), "2.81 Fixed rate or coupon payment frequency period leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), "2.82 Fixed rate or coupon payment frequency period multiplier leg 1");
		startNode.addLabel(Arrays.asList("identifierOfFloatingRateOfLeg1"), "2.83 - Identifier of the floating rate of leg 1");
		startNode.addLabel(Arrays.asList("indicatorOfTheFloatingRateOfLeg1"), "2.84 Indicator of the floating rate of leg 1");
		startNode.addLabel(Arrays.asList("nameOfTheFloatingRateOfLeg1"), "2.85 Name of the Floating Rate of Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionOfLeg1"), "2.86 Floating rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodOfLeg1"), "2.87 Floating rate payment frequency period of leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), "2.88 Floating rate payment frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg1TimePeriod"), "2.89 Floating rate reference period of leg 1 - time period");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg1Multiplier"), "2.90 Floating rate reference period of leg 1 - multiplier");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodOfLeg1"), "2.91 Floating rate reset frequency period of Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierLeg1"), "2.92 Floating rate reset frequency multiplier of leg 1");
		startNode.addLabel(Arrays.asList("fixedRateOfLeg2"), "2.95 Fixed Rate of leg 2");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionLeg2"), "2.96 Fixed rate day count convention leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodLeg2"), "2.97 Fixed rate payment frequency period leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), "2.98 Fixed rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("identifierOfFloatingRateOfLeg2"), "2.99 - Identifier of the floating rate of leg 2");
		startNode.addLabel(Arrays.asList("indicatorOfTheFloatingRateOfLeg2"), "2.100 Indicator of the floating rate of leg 2");
		startNode.addLabel(Arrays.asList("nameOfTheFloatingRateOfLeg2"), "2.101 Name of the Floating Rate of Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionOfLeg2"), "2.102 Floating rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodOfLeg2"), "2.103 Floating rate payment frequency period of leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), "2.104 Floating rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg2TimePeriod"), "2.105 Floating rate reference period of leg 2 - time period");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg2Multiplier"), "2.106 Floating rate reference period of leg 2 - multiplier");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodOfLeg2"), "2.107 Floating rate reset frequency period of Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierLeg2"), "2.108 Floating rate reset frequency multiplier of leg 2");
		startNode.addLabel(Arrays.asList("exchangeRate"), "2.113 Exchange Rate 1");
		startNode.addLabel(Arrays.asList("forwardExchangeRate"), "2.114 Forward exchange rate");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "2.115 Exchange Rate Basis");
		startNode.addLabel(Arrays.asList("baseProduct"), "2.116 Base Product");
		startNode.addLabel(Arrays.asList("subProduct"), "2.117 Sub Product");
		startNode.addLabel(Arrays.asList("furtherSubProduct"), "2.118 Further sub-product");
		startNode.addLabel(Arrays.asList("deliveryPoint"), "2.119 Delivery point or zone");
		startNode.addLabel(Arrays.asList("interconnectionPoint"), "2.120 Interconnection Point");
		startNode.addLabel(Arrays.asList("loadType"), "2.121 Load type");
		startNode.addLabel(Arrays.asList("optionType"), "2.132 Option type");
		startNode.addLabel(Arrays.asList("optionStyle"), "2.133 Option Style");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "2.139 Option Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "2.140 Option Premium Currency");
		startNode.addLabel(Arrays.asList("optionPremiumPaymentDate"), "2.141 Option Premium Payment Date");
		startNode.addLabel(Arrays.asList("maturityDateOfTheUnderlying"), "2.142 Maturity date of the underlying");
		startNode.addLabel(Arrays.asList("seniority"), "2.143 Seniority");
		startNode.addLabel(Arrays.asList("referenceEntity"), "2.144 Reference Entity");
		startNode.addLabel(Arrays.asList("series"), "2.145 Series");
		startNode.addLabel(Arrays.asList("version"), "2.146 Version");
		startNode.addLabel(Arrays.asList("indexFactor"), "2.147 Index factor");
		startNode.addLabel(Arrays.asList("tranche"), "2.148 Tranche");
		startNode.addLabel(Arrays.asList("cdSIndexAttachmentPoint"), "2.149 CDS Index Attachment Point");
		startNode.addLabel(Arrays.asList("cdSIndexDetachmentPoint"), "2.150 CDS Index Detachment Point");
		startNode.addLabel(Arrays.asList("collateralPortfolioIndicator"), "2.26 Collateral Portfolio Indicator");
		startNode.addLabel(Arrays.asList("collateralPortfolioCode"), "2.27 Collateral Portfolio Code");
		startNode.addLabel(Arrays.asList("actionType"), "2.151 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "2.152 Event Type");
		startNode.addLabel(Arrays.asList("eventDate"), "2.153 Event Date");
		startNode.addLabel(Arrays.asList("level"), "2.154 Level");
		
		LabelNode executionAgentNode = new LabelNode();
		executionAgentNode.addLabel(Arrays.asList("executionAgentReportingParty"), "1.21 Execution Agent Reporting Party");
		executionAgentNode.addLabel(Arrays.asList("executionAgentReportingCounterparty"), "1.21 Execution Agent Reporting Counterparty");
		
		LabelNode priceAndNotationNode = new LabelNode();
		priceAndNotationNode.addLabel(Arrays.asList("priceMonetary"), "2.48 Price (Monetary)");
		priceAndNotationNode.addLabel(Arrays.asList("pricePercentage"), "2.48 Price (Percentage)");
		priceAndNotationNode.addLabel(Arrays.asList("priceCurrency"), "2.49 Price Currency");
		priceAndNotationNode.addLabel(Arrays.asList("priceNotation"), "2.48 Price Notation (Non Reportable)");
		
		LabelNode packageTransactionPriceNode = new LabelNode();
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPriceMonetary"), "2.53 Package Transaction Price (Monetary)");
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPricePercentage"), "2.53 Package Transaction Price (Percentage)");
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPriceBasis"), "2.53 Package Transaction Price (Basis)");
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "2.53 Package Transaction Price Notation");
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "2.54 Package Transaction Price Currency");
		
		LabelNode spreadOfLeg1Node = new LabelNode();
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Monetary"), "2.93 Spread of Leg 1 (Monetary)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Percentage"), "2.93 Spread of Leg 1 (Percentage)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Basis"), "2.93 Spread of Leg 1 (Basis)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadCurrencyOfLeg1"), "2.94 Spread Currency of Leg 1");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Notation"), "2.93 Spread of Leg 1 Notation (Non Reportable)");
		
		LabelNode spreadOfLeg2Node = new LabelNode();
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Monetary"), "2.109 Spread of Leg 2 (Monetary)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Percentage"), "2.109 Spread of Leg 2 (Percentage)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Basis"), "2.109 Spread of Leg 2 (Basis)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadCurrencyOfLeg2"), "2.110 Spread Currency of Leg 2");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Notation"), "2.109 Spread of Leg 2 Notation (Non Reportable)");
		
		LabelNode packageTransactionSpreadNode = new LabelNode();
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadMonetary"), "2.111 Package transaction spread (Monetary)");
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadPercentage"), "2.111 Package transaction spread (Percentage)");
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadBasis"), "2.111 Package transaction spread (Basis)");
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "2.111 Package transaction spread Notation (Non Reportable)");
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "2.112 Package transaction spread currency");
		
		LabelNode strikePriceAndNotationNode = new LabelNode();
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceMonetary"), "2.134 Strike Price (Monetary)");
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePricePercentage"), "2.134 Strike Price (Percentage)");
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceCurrency"), "2.138 Strike price currency/currency pair");
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceNotation"), "2.134 Strike Price Notation (Non Reportable)");
		
		LabelNode fCAUKEMIRNonReportableNode = new LabelNode();
		fCAUKEMIRNonReportableNode.addLabel(Arrays.asList("enrichment"), "Enrichment Data");
		
		startNode.addOutgoingEdge("executionAgent", executionAgentNode);
		startNode.addOutgoingEdge("price", priceAndNotationNode);
		startNode.addOutgoingEdge("packageTransactionPrice", packageTransactionPriceNode);
		startNode.addOutgoingEdge("spreadOfLeg1", spreadOfLeg1Node);
		startNode.addOutgoingEdge("spreadOfLeg2", spreadOfLeg2Node);
		startNode.addOutgoingEdge("packageTransactionSpread", packageTransactionSpreadNode);
		startNode.addOutgoingEdge("strikePrice", strikePriceAndNotationNode);
		startNode.addOutgoingEdge("nonReportable", fCAUKEMIRNonReportableNode);
	}
}
