package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import java.util.ArrayList;
import java.util.List;


@ImplementedBy(DaysOfTheWeekRule.DaysOfTheWeekRuleDefault.class)
public abstract class DaysOfTheWeekRule implements ReportFunction<ReportableDelivery, List<String>> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<String> evaluate(ReportableDelivery input) {
		List<String> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<String> doEvaluate(ReportableDelivery input);

	public static class DaysOfTheWeekRuleDefault extends DaysOfTheWeekRule {
		@Override
		protected List<String> doEvaluate(ReportableDelivery input) {
			List<String> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<String> assignOutput(List<String> output, ReportableDelivery input) {
			output = MapperS.of(input)
				.mapSingleToList(item -> item.<String>mapC("getDaysOfTheWeek", reportableDelivery -> reportableDelivery.getDaysOfTheWeek())).getMulti();
			
			return output;
		}
	}
}
