package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalAmountScheduleAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg2Rule.NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg2RuleDefault.class)
public abstract class NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg2Rule implements ReportFunction<QuantityReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalAmountScheduleAmountRule cDENotionalAmountScheduleAmountRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(QuantityReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(QuantityReportablePeriod input);

	public static class NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg2RuleDefault extends NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(QuantityReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, QuantityReportablePeriod input) {
			output = cDENotionalAmountScheduleAmountRule.evaluate(input);
			
			return output;
		}
	}
}
