package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.fca.ukemir.refit.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.fca.ukemir.refit.trade.functions.UKEMIRNotionalAmountPeriodLeg2;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountScheduleLeg2Rule.NotionalAmountScheduleLeg2RuleDefault.class)
public abstract class NotionalAmountScheduleLeg2Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalAmountScheduleLeg2Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EffectiveDateOfTheNotionalAmountOfLeg2Rule effectiveDateOfTheNotionalAmountOfLeg2Rule;
	@Inject protected EndDateOfTheNotionalAmountOfLeg2Rule endDateOfTheNotionalAmountOfLeg2Rule;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg2Rule notionalAmountInEffectOnAssociatedEffectiveDateOfLeg2Rule;
	@Inject protected UKEMIRNotionalAmountPeriodLeg2 uKEMIRNotionalAmountPeriodLeg2;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalAmountScheduleLeg2Report> evaluate(TransactionReportInstruction input) {
		List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalAmountScheduleLeg2Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalAmountScheduleLeg2Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalAmountScheduleLeg2Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalAmountScheduleLeg2RuleDefault extends NotionalAmountScheduleLeg2Rule {
		@Override
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> assignOutput(List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperC<QuantityReportablePeriod> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<QuantityReportablePeriod>of(uKEMIRNotionalAmountPeriodLeg2.evaluate(item.get())));
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(NotionalAmountScheduleLeg2Report.builder()
					.setAmount(notionalAmountInEffectOnAssociatedEffectiveDateOfLeg2Rule.evaluate(item.get()))
					.setEffectiveDate(effectiveDateOfTheNotionalAmountOfLeg2Rule.evaluate(item.get()))
					.setEndDate(endDateOfTheNotionalAmountOfLeg2Rule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
