package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.PackageTransactionSpread;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class PackageTransactionSpreadTypeFormatValidator implements Validator<PackageTransactionSpread> {

	private List<ComparisonResult> getComparisonResults(PackageTransactionSpread o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("packageTransactionSpreadMonetary", o.getPackageTransactionSpreadMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("packageTransactionSpreadPercentage", o.getPackageTransactionSpreadPercentage(), of(11), of(10), empty(), empty()), 
				checkNumber("packageTransactionSpreadBasis", o.getPackageTransactionSpreadBasis(), of(5), empty(), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionSpread o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PackageTransactionSpread", ValidationResult.ValidationType.TYPE_FORMAT, "PackageTransactionSpread", path, "", res.getError());
				}
				return success("PackageTransactionSpread", ValidationResult.ValidationType.TYPE_FORMAT, "PackageTransactionSpread", path, "");
			})
			.collect(toList());
	}

}
