package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2100_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2100_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2100_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2100_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if indicatorOfTheFloatingRateOfLeg2 exists then [\"ESTR\", \"SONA\", \"SOFR\", \"EONA\", \"EONS\", \"EURI\", \"EUUS\", \"EUCH\", \"GCFR\", \"ISDA\", \"LIBI\", \"LIBO\", \"MAAA\", \"PFAN\", \"TIBO\", \"STBO\", \"BBSW\", \"JIBA\", \"BUBO\", \"CDOR\", \"CIBO\", \"MOSP\", \"NIBO\", \"PRBO\", \"TLBO\", \"WIBO\", \"TREA\", \"SWAP\", \"FUSW\", \"EFFR\", \"OBFR\", \"CZNA\", \"TONA\"] any = indicatorOfTheFloatingRateOfLeg2";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2100_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getIndicatorOfTheFloatingRateOfLeg2", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getIndicatorOfTheFloatingRateOfLeg2())).getOrDefault(false)) {
						return areEqual(MapperC.<String>of(MapperS.of("ESTR"), MapperS.of("SONA"), MapperS.of("SOFR"), MapperS.of("EONA"), MapperS.of("EONS"), MapperS.of("EURI"), MapperS.of("EUUS"), MapperS.of("EUCH"), MapperS.of("GCFR"), MapperS.of("ISDA"), MapperS.of("LIBI"), MapperS.of("LIBO"), MapperS.of("MAAA"), MapperS.of("PFAN"), MapperS.of("TIBO"), MapperS.of("STBO"), MapperS.of("BBSW"), MapperS.of("JIBA"), MapperS.of("BUBO"), MapperS.of("CDOR"), MapperS.of("CIBO"), MapperS.of("MOSP"), MapperS.of("NIBO"), MapperS.of("PRBO"), MapperS.of("TLBO"), MapperS.of("WIBO"), MapperS.of("TREA"), MapperS.of("SWAP"), MapperS.of("FUSW"), MapperS.of("EFFR"), MapperS.of("OBFR"), MapperS.of("CZNA"), MapperS.of("TONA")), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getIndicatorOfTheFloatingRateOfLeg2", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getIndicatorOfTheFloatingRateOfLeg2()), CardinalityOperator.Any);
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2100_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
