package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.StrikePriceAndNotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.0
 */
@RosettaDataRule("StrikePriceAndNotationMonetaryOrPercentage")
@ImplementedBy(StrikePriceAndNotationMonetaryOrPercentage.Default.class)
public interface StrikePriceAndNotationMonetaryOrPercentage extends Validator<StrikePriceAndNotation> {
	
	String NAME = "StrikePriceAndNotationMonetaryOrPercentage";
	String DEFINITION = "optional choice strikePriceMonetary, strikePricePercentage";
	
	class Default implements StrikePriceAndNotationMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceAndNotation strikePriceAndNotation) {
			ComparisonResult result = executeDataRule(strikePriceAndNotation);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "StrikePriceAndNotation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "StrikePriceAndNotation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(StrikePriceAndNotation strikePriceAndNotation) {
			try {
				return choice(MapperS.of(strikePriceAndNotation), Arrays.asList("strikePriceMonetary", "strikePricePercentage"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements StrikePriceAndNotationMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, StrikePriceAndNotation strikePriceAndNotation) {
			return Collections.emptyList();
		}
	}
}
