package drr.regulation.jfsa.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.standards.iosco.cde.reports.CDEExcessCollateralCollectedByTheReportingCounterpartyRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(ExcessCollateralCollectedByTheReportingCounterpartyRule.ExcessCollateralCollectedByTheReportingCounterpartyRuleDefault.class)
public abstract class ExcessCollateralCollectedByTheReportingCounterpartyRule implements ReportFunction<CollateralReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEExcessCollateralCollectedByTheReportingCounterpartyRule cDEExcessCollateralCollectedByTheReportingCounterpartyRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(CollateralReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(CollateralReportInstruction input);

	public static class ExcessCollateralCollectedByTheReportingCounterpartyRuleDefault extends ExcessCollateralCollectedByTheReportingCounterpartyRule {
		@Override
		protected BigDecimal doEvaluate(CollateralReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, CollateralReportInstruction input) {
			output = cDEExcessCollateralCollectedByTheReportingCounterpartyRule.evaluate(input);
			
			return output;
		}
	}
}
