package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalAmountScheduleEndDateRule;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountScheduleLeg2EndDateRule.NotionalAmountScheduleLeg2EndDateRuleDefault.class)
public abstract class NotionalAmountScheduleLeg2EndDateRule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalAmountScheduleEndDateRule cDENotionalAmountScheduleEndDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class NotionalAmountScheduleLeg2EndDateRuleDefault extends NotionalAmountScheduleLeg2EndDateRule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalAmountScheduleEndDateRule.evaluate(input);
			
			return output;
		}
	}
}
