package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalQuantityScheduleEffectiveDateRule;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg1EffectiveDateRule.NotionalQuantityScheduleLeg1EffectiveDateRuleDefault.class)
public abstract class NotionalQuantityScheduleLeg1EffectiveDateRule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalQuantityScheduleEffectiveDateRule cDENotionalQuantityScheduleEffectiveDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class NotionalQuantityScheduleLeg1EffectiveDateRuleDefault extends NotionalQuantityScheduleLeg1EffectiveDateRule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalQuantityScheduleEffectiveDateRule.evaluate(input);
			
			return output;
		}
	}
}
