package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.event.FeaturePayment;
import cdm.observable.event.Trigger;
import cdm.observable.event.TriggerEvent;
import cdm.product.template.Knock;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SingleBarrierPriceCurrencyRule.SingleBarrierPriceCurrencyRuleDefault.class)
public abstract class SingleBarrierPriceCurrencyRule implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class SingleBarrierPriceCurrencyRuleDefault extends SingleBarrierPriceCurrencyRule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<FieldWithMetaString> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final Boolean _boolean = isOption.evaluate(productForEvent.evaluate(item.get()));
					if ((_boolean == null ? false : _boolean)) {
						if (exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel())).and(notExists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
							return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn()).<FeaturePayment>map("getFeaturePayment", triggerEvent -> triggerEvent.getFeaturePayment()).<FieldWithMetaString>map("getCurrency", featurePayment -> featurePayment.getCurrency()).get());
						}
						if (notExists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn())).and(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()))).getOrDefault(false)) {
							return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()).<FeaturePayment>map("getFeaturePayment", triggerEvent -> triggerEvent.getFeaturePayment()).<FieldWithMetaString>map("getCurrency", featurePayment -> featurePayment.getCurrency()).get());
						}
						return MapperS.<FieldWithMetaString>ofNull();
					}
					return MapperS.<FieldWithMetaString>ofNull();
				});
			output = thenArg1
				.mapSingleToItem(item -> {
					final FieldWithMetaString fieldWithMetaString = item.get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString == null ? null : fieldWithMetaString.getValue())));
				}).get();
			
			return output;
		}
	}
}
