package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.observable.event.Trigger;
import cdm.observable.event.TriggerEvent;
import cdm.product.template.Knock;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SingleBarrierPriceDecimalRule.SingleBarrierPriceDecimalRuleDefault.class)
public abstract class SingleBarrierPriceDecimalRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SingleBarrierPriceDecimalRuleDefault extends SingleBarrierPriceDecimalRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final Boolean _boolean = isOption.evaluate(productForEvent.evaluate(item.get()));
					if ((_boolean == null ? false : _boolean)) {
						if (exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn())).and(notExists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
							return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage()).get());
						}
						if (notExists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn())).and(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
							return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage()).get());
						}
						return MapperS.<BigDecimal>ofNull();
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
